//
//  NSView+MCReportAdditions.h
//  Composer
//
//  Created by Alykhan Jetha on 11/06/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCReportElement;

@interface NSView (MCCAdditions)

- (MCReportElement *)reportElementUnderPoint:(NSPoint)point; 
- (void)dragReportElementWithEvent:(NSEvent *)theEvent;

- (NSSet *)viewsIntersectingRect:(NSRect)rect; 
- (NSRect)drawingBoundsForViews:(NSArray *)views;
- (NSRect)boundsForViews:(NSArray *)views;
- (NSRect)frameForViews:(NSArray *)views;


- (void)setYOrigin:(float)aNewY;
- (float)yOrigin;

- (void)setXOrigin:(float)aNewX;
- (float)xOrigin;

- (void)setWidth:(float)aNewWidth;
- (float)width;

- (void)setHeight:(float)aNewHeight;
- (float)height;

// used for sorting
- (float)layoutMinY;

- (float)maxYOfHighestSubview;
- (float)totalHeightOfSubviews;
- (float)totalWidthOfSubviews;
- (float)maxHeightOfSubviews;

- (NSView *)firstShallowSubviewOfClass:(Class)aClass;
- (NSArray *)shallowSubviewsOfClass:(Class)aClass;


- (BOOL)shouldStretchToMatchLayoutWidth;

- (NSArray *)viewHierarchyClassnames;



@end
